/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include "idct.h"
#include "metypes.h"
#include <imagelib.h>

#pragma DATA_SECTION(interBuffer,"interBuffer_SECTION");
#pragma DATA_SECTION(local_block,"block_SECTION");
short   interBuffer[72];
short   local_block[64];

void
idct_HW(short *block)
{

    int     i;
    //printf("Inside IDCT\n");
    //IMG_fdct_8x8(block,interBuffer);  
    /* Theoretical results of 2-D DCT for image block Q16.0 format 

       32    15     6    -1    -1    -2    -1     1
       7     3    -1    -4     0     2     1    -1
       -3    -2     1     3    -3    -1     3    -1
       7     1    -1     0     0     0     1    -2
       0     4     3    -2    -2     1    -1     3
       -4     2     2    -3     1     0    -1     2
       -2    -2    -1    -2    -2     3     1    -1
       3     0    -2     1    -1     0     2    -1      
     */

    for (i = 0; i < 64; i++)
    {
        local_block[i] = _shl(block[i], 3);
    }

    IMG_idct_8x8(local_block, interBuffer);
    memcpy(block, local_block, 64);
}
